*****************************************
*REPLICATION FILE FOR
*Kam, Cindy D. "Risk Attitudes and Participation."
*American Journal of Political Science
**PLEASE NOTE THAT THIS FILE IS ORGANIZED BY DATASET

***************************
*******ANES PANEL STUDY**********
//creating the dataset
/* use "C:\CDK WORK\risk\ANES panel\ANES_Wave22_Kam\anes_wave22_kam.dta", clear
sort caseid_so
save, replace

//download dataset from ANES and merge in the new wave
use "C:\anes\anes2008_2009panel\anes2008_2009panel.dta"
gen caseid_so = caseid
sort caseid_so
merge caseid_so using "C:\CDK WORK\risk\NES panel\ANES_Wave22_Kam\anes_wave22_kam.dta"
save "C:\CDK WORK\risk\NES panel\nes2008_2009panel.dta", replace */


//APPENDIX TABLE A1
svyset [pweight=weights], strata(stratum)
gen female = der01-1
gen age01 = (der02-18)/(90-18)
recode der04 (1=0 "white")(2=1 "black")(3=2 "Hispanic")(4=3 "Other"), gen(race)
recode der04 (2=1)(1 3=0)(else=.), gen(black)
recode der04 (3=1)(1 2=0)(else=.), gen(hisp)
recode der05 (1=0 "<HS")(2=.25)(3=.5)(4=.75)(5=1 "grad degree")(else=.), gen(ed5cat)
recode der06 (1/9 = 0)(10/11=.25)(12/13=.5)(14/16=.75)(17/19=1)(else=.), gen(inc5cat)
recode der08w1 der08w9 der08w10 der08w11 (0=0)(1=.17)(2=.33)(3=.5)(4=.67)(5=.83)(6=1)(else=.), gen(pid7cat1 pid7cat9 pid7cat10 pid7cat11)
lab def pid7 0"str Dem" 1"str GOP"
lab val pid7cat1 pid7cat9 pid7cat10 pid7cat11 pid7
recode der09w1 der09w2 der09w6 der09w10 der09w11 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(lc7cat1 lc7cat2 lc7cat6 lc7cat10 lc7cat11)
lab def lc7 0"ext Lib" 1"ext con"
lab val lc7cat1 lc7cat2 lc7cat6 lc7cat10 lc7cat11 lc7
recode pid7cat1 (0 1=1)(.17 .83=.67)(.33 .67 = .33)(.5=0), gen(strpid1)
svy: mean der02
svy: mean female
svy: tab der05 if der05>0
svy: tab der06 if der06>0
svy: mean pid7cat1
svy: mean lc7cat1
svy: tab race

//creating the risk scale
tab1 qrisk1-qrisk4
recode qrisk1 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(qrisk1r)
recode qrisk2 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=.), gen(qrisk2r)
recode qrisk3a (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3ar)
recode qrisk3b (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3br)
recode qrisk3c (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3cr)
recode qrisk3d (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3dr)
recode qrisk4 (1=0)(2=.33)(3=.67)(4=1)(else=.), gen(qrisk4r)
//due to programming error, Q7 response options were not reversed//
sum qrisk1r-qrisk4r
alpha qrisk1r-qrisk4r
factor qrisk1r-qrisk4r
svyset [pweight=weights], strata(stratum)

gen riskscale = (qrisk1r+qrisk2r+qrisk3ar+qrisk3br+qrisk3cr+qrisk3dr+qrisk4r)/7
sum riskscale
egen riskmis = rowmiss(qrisk1r-qrisk4r)
tab riskmis
recode qrisk1r qrisk2r qrisk3ar qrisk3br qrisk3cr qrisk3dr qrisk4r (.=0), gen(q1a q2a q3a q4a q5a q6a q7a)
replace riskscale = (q1a+q2a+q3a+q4a+q5a+q6a+q7a)/6 if riskmis==1
replace riskscale = (q1a+q2a+q3a+q4a+q5a+q6a+q7a)/5 if riskmis==2
factor qrisk1r-qrisk4r
lab def riskscale 0"risk averse" 1"risk accepting"
lab val riskscale riskscale
lab var riskscale "Risk Orientations"

svy: mean qrisk1r qrisk2r qrisk3ar qrisk3br qrisk3cr qrisk3dr qrisk4r riskscale

*****PARTIAL CORRELATIONS WITH INDIVIDUAL DIFFERENCES
pcorr riskscale female age01 ed5cat inc5cat pid7cat1 lc7cat1 black hisp


**********POLITICAL PARTICIPATION**********
recode w6y2 w6y3 w6y4 w6y5 w6y6 w6y7 w6y8 w6y9 w6y10 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=.), gen(rally6 schoolbd6 epetition6 petition6 reldon6 poldon6 polmtg6 invitemtg6 flyers6)
svyset [pweight=weights], strata(stratum)
svy: mean rally6 
svy: mean schoolbd6 
svy: mean epetition6 
svy: mean petition6 
svy: mean reldon6 
svy: mean poldon6 
svy: mean polmtg6 
svy: mean invitemtg6 
svy: mean flyers6
pwcorr rally6 schoolbd6 epetition6 petition6 reldon6 poldon6 polmtg6 invitemtg6 flyers6

recode w6y21 w6y22 w6y23 w6y24 w6y25 w6y26 w6y27 w6y28 w6y29 (1=1)(2=0)(else=.), gen(rally6b schoolbd6b epetition6b petition6b reldon6b poldon6b polmtg6b invitemtg6b flyers6b)
svy: proportion rally6b 
svy: proportion schoolbd6b 
svy: proportion epetition6b 
svy: proportion petition6b 
svy: proportion reldon6b 
svy: proportion poldon6b 
svy: proportion polmtg6b 
svy: proportion invitemtg6b 
svy: proportion flyers6b
pwcorr rally6b schoolbd6b epetition6b petition6b reldon6b poldon6b polmtg6b invitemtg6b flyers6b

*****TABLE 3
svy: oprobit rally6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store rally
svy: oprobit schoolbd6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store schoolbd
svy: oprobit epetition6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store epetition
svy: oprobit petition6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store petition
svy: oprobit reldon6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store reldon
svy: oprobit poldon6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store poldon
svy: oprobit polmtg6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store polmtg
svy: oprobit invitemtg6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store invite
svy: oprobit flyers6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store flyers
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) se eq(1) style(col) stats(N)
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) star(.1 .05 .01)  eq(1) style(col) stats(N)


*****TABLE 4
svy: probit rally6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store rally
svy: probit schoolbd6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store schoolbd
svy: probit epetition6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store epetition
svy: probit petition6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store petition
svy: probit reldon6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store reldon
svy: probit poldon6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store poldon
svy: probit polmtg6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store polmtg
svy: probit invitemtg6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store invite
svy: probit flyers6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store flyers
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) se eq(1) style(col) stats(N)
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) star(.1 .05 .01)  eq(1) style(col) stats(N)


*****FIGURE 1*****
svy: oprobit rally6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

svy: oprobit petition6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

svy: oprobit flyers6 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

svy: probit schoolbd6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

svy: probit polmtg6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

svy: probit invitemtg6b riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
matrix b = e(b)'
matrix list b, nonames
matrix V = e(V)
matlist V, nohalf nonames line(col)

recode w11zd21 w11zd22 w11zd23 w11zd24 w11zd25 w11zd26 w11zd27 w11zd28 w11zd29 (1=1)(2=0)(else=.), gen(rally11 schoolbd11 epetition11 petition11 reldon11 poldon11 polmtg11 invite11 flyers11)

svy: probit rally11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*yes, risk accepting R has joined protest*/
est store rally
svy: probit schoolbd11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*yes, risk accepting R has attended meeting of school board*/
est store schoolbd
svy: probit epetition11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*yes, risk accepting R has signed petition on internet*/
est store epetition
svy: probit petition11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*yes, risk accepting R has signed petition on paper*/
est store petition
svy: probit reldon11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*OPPOSITE SIGN: risk averse R has given money to rel org*/
est store reldon
svy: probit poldon11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*ns on donating to pol org*/
est store poldon
svy: probit polmtg11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*risk accepting R has attended meeting*/
est store polmtg
svy: probit invite11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*risk accepting R has invited someone else to meeting*/
est store invite
svy: probit flyers11 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp /*risk accepting R has distributed info or adverts*/
est store flyers
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) se eq(1) style(col) stats(N)
est table rally schoolbd epetition petition reldon poldon polmtg invite flyers, b(%9.2f) star(.1 .05 .01)  eq(1) style(col) stats(N)

*TURNOUT IN 2008
tab der15
recode der15 (1=1)(2=0)(else=.), gen(votegen08)
tab der10
recode der10 (1=0)(2/5=1)(else=.), gen(voteprim08)
svy: probit votegen08 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store votegen08 
svy: probit voteprim08 riskscale female age01 strpid1 lc7cat1 ed5cat inc5cat black hisp 
est store voteprim08 
est table voteprim08 votegen08, b(%9.2f) se 
est table voteprim08 votegen08, b(%9.2f) star(.1 .05 .01) stats(N) 




**********************
*****STABILITY COEFFICIENT
use "C:/CDK WORK/risk/TESS Jul 2008/tess126_allRs.dta", clear
recode q1 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=9), gen(q1r)
recode q2 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=9), gen(q2r)
recode q3 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q3r)
recode q4 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q4r)
recode q5 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q5r)
recode q6 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q6r)
recode q7 (1=1)(2=.67)(3=.33)(4=0)(else=9), gen(q7r)

egen riskmis = anycount(q1r-q7r), val(9)
tab riskmis
recode q1r q2r q3r q4r q5r q6r q7r(9=0), gen(q1a q2a q3a q4a q5a q6a q7a)
mvdecode q1r q2r q3r q4r q5r q6r q7r, mv(9)
gen riskscale=(q1r+q2r+q3r+q4r+q5r+q6r+q7r)/7
replace riskscale = (q1a+q2a+q3a+q4a+q5a+q6a+q7a)/6 if riskmis==1
lab var riskscale "Risk Orientations "
lab def risk 0"Risk Averse" 1"Risk Accepting"
lab val riskscale risk
*****SECOND WAVE
recode q1_2 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=9), gen(q1r_2)
recode q2_2 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=9), gen(q2r_2)
recode q3_2 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q3r_2)
recode q4_2 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q4r_2)
recode q5_2 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q5r_2)
recode q6_2 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=9), gen(q6r_2)
recode q7_2 (1=1)(2=.67)(3=.33)(4=0)(else=9), gen(q7r_2)

egen riskmis_2 = anycount(q1r_2-q7r_2), val(9)
tab riskmis_2

recode q1r_2 q2r_2 q3r_2 q4r_2 q5r_2 q6r_2 q7r_2 (9=0), gen(q1a_2 q2a_2 q3a_2 q4a_2 q5a_2 q6a_2 q7a_2)

mvdecode q1r_2 q2r_2 q3r_2 q4r_2 q5r_2 q6r_2 q7r_2, mv(9)

gen risk_2=(q1r_2+q2r_2+q3r_2+q4r_2+q5r_2+q6r_2+q7r_2)/7
replace risk_2 = (q1a_2+q2a_2+q3a_2+q4a_2+q5a_2+q6a_2+q7a_2)/6 if riskmis_2==1

sum risk_2
lab var risk_2 " "
lab val risk_2 risk
tab risk_2

alpha q1r_2 q2r_2 q3r_2 q4r_2 q5r_2 q6r_2 q7r_2
corr riskscale risk_2
*CORRELATION IS 0.81
alpha q1r q2r q3r q4r q5r q6r q7r



**********************************************
****LAB STUDY, FOR CDQ CORRELATION*
use "C:/CDK WORK/risk/RIPS Spring 2009 risk.dta", clear
corr caution1-caution7
recode caution1 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1), gen(risk1)
recode caution2 (1=1)(2=.75)(3=.5)(4=.25)(5=0), gen(risk2)
recode caution3 caution4 caution5 caution6 (1=1)(2=.75)(3=.5)(4=.25)(5=0), gen(risk3 risk4 risk5 risk6)
recode caution7 (1=1)(2=.67)(3=.33)(4=0), gen(risk7)
sum risk1-risk7
factor risk1-risk7
alpha risk1-risk7
//alpha = 0.7227
corr risk1-risk7
gen riskscale = (risk1+risk2+risk3+risk4+risk5+risk6+risk7)/7
lab var riskscale "Risk Orientations"
histogram riskscale, title("Lab Study 2") xlabel(0 "Risk Averse" 1 "Risk Accepting") graphregion(margin(r+10)) percent bin(20) name(lab2, replace) scheme(s1mono)
graph export lab2.tif, replace
sum riskscale

encode e1, gen(cdq1) label(e1_)
encode e2, gen(cdq2) label(e2)
encode e3, gen(cdq3) label(e3)
encode e4, gen(cdq4) label(e4)
encode e5, gen(cdq5) label(e5)
encode e6, gen(cdq6) label(e6)
encode e7, gen(cdq7) label(e7)
encode e8, gen(cdq8) label(e8)
encode e9, gen(cdq9) label(e9)
encode e10, gen(cdq10) label(e10)
encode e11, gen(cdq11) label(e11)
encode e12, gen(cdq12) label(e12)

recode cdq1 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq1r)
recode cdq2 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq2r)
recode cdq3 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq3r)
recode cdq4 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq4r)
recode cdq5 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq5r)
recode cdq6 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq6r)
recode cdq7 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq7r)
recode cdq8 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq8r)
recode cdq9 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq9r)
recode cdq10 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq10r)
recode cdq11 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq11r)
recode cdq12 (1=0)(2=1)(3=.8)(4=.6)(5=.4)(6=.2), gen(cdq12r)

alpha cdq1r-cdq12r
//alpha = 0.6697
corr cdq1r-cdq12r

gen cdqindex = (cdq1r+cdq2r+cdq3r+cdq4r+cdq5r+cdq6r+cdq7r+cdq8r+cdq9r+cdq10r+cdq11r+cdq12r)/12
corr cdqindex riskscale
lab var cdqindex "CDQ Index"


***********************************************
******NES DATA ANALYSIS, MERGING ON 2010 WAVE FOR TIPI
//DOWNLOAD ANES 2010 WAVE FROM ANES
use "C:\anes\anes2010paneldta\anes2010panel_dataset.dta", clear
sort caseid
save, replace

use "C:\CDK WORK\risk\NES panel\nes2008_2009panel.dta", clear
sort caseid
save, replace
duplicates tag caseid, gen(dup)
merge caseid using "C:\anes\anes2010paneldta\anes2010panel_dataset.dta", _merge(panelmerge)
//there are 4 duplicate cases


//f1j
tab1 f1j2-f1j11
mvdecode f1j2-f1j11, mv(-6 -5)
gen extraversion = (f1j7-f1j2+6)/12
gen agreeableness= (f1j3-f1j8+6)/12
gen conscientiousness= (f1j9-f1j4+6)/12
gen neuroticism = (f1j10-f1j5+6)/12
gen openness = (f1j11-f1j6+6)/12
sum extra-open

tab1 qrisk1-qrisk4
recode qrisk1 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(qrisk1r)
recode qrisk2 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=.), gen(qrisk2r)
recode qrisk3a (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3ar)
recode qrisk3b (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3br)
recode qrisk3c (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3cr)
recode qrisk3d (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(qrisk3dr)
recode qrisk4 (1=0)(2=.33)(3=.67)(4=1)(else=.), gen(qrisk4r)
//due to programming error, Q7 response options were not reversed//
gen riskscale = (qrisk1r+qrisk2r+qrisk3ar+qrisk3br+qrisk3cr+qrisk3dr+qrisk4r)/7
egen riskmis = rowmiss(qrisk1r-qrisk4r)
recode qrisk1r qrisk2r qrisk3ar qrisk3br qrisk3cr qrisk3dr qrisk4r (.=0), gen(q1a q2a q3a q4a q5a q6a q7a)
replace riskscale = (q1a+q2a+q3a+q4a+q5a+q6a+q7a)/6 if riskmis==1
replace riskscale = (q1a+q2a+q3a+q4a+q5a+q6a+q7a)/5 if riskmis==2
lab def riskscale 0"risk averse" 1"risk accepting"
lab val riskscale riskscale
lab var riskscale "Risk Orientations"

pwcorr riskscale extraversion agreeableness conscientiousness neuroticism openness, sig


***********************************************
*****SSI DATA*****
//SSI coding
//July 17, 2011
use "C:/CDK WORK/risk/SSI risk.dta", clear

gen age = (2011-yearborn)
replace age = . if yearborn==-99
sum age
drop if age<18 

//demographics
recode educ (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(ed7cat)
recode gender (1=0)(2=1)(else=.), gen(female)
recode income (1=0)(2=.2)(3=.4)(4=.6)(5=.8)(6=1)(else=.), gen(faminc)
tab employ
tab race
recode race (1=0)(2/6=1)(else=.), gen(nonwhite)
recode race (1 3/5=0)(2=1)(else=.), gen(black)
recode race (1 2 3 5=0)(4=1)(else=.), gen(hisp)
recode race (1 2 4=0)(3 5=1)(else=.), gen(raceoth)

gen age01 = (age-17)/(93-17)
recode age (18/29 = 1)(30/94=0), gen(age1829)
recode age (30/39 = 1)(18/29 40/94=0), gen(age3039)
recode age (40/49 = 1)(18/39 50/94=0), gen(age4049)
recode age (50/59 = 1)(18/49 60/94=0), gen(age5059)
recode age (60/69 = 1)(18/59 70/94=0), gen(age6069)
recode age (70/93 = 1)(18/69=0), gen(age70pl)
sum age*

sum female ed7cat faminc age01
tab educ
tab income

gen pid7cat = .
replace pid7cat = 1 if dem1==1
replace pid7cat = .83 if dem1==2
replace pid7cat = .67 if other1==2
replace pid7cat = .5 if other1==3
replace pid7cat = .33 if other1==1
replace pid7cat = .17 if rep1==2
replace pid7cat = 0 if rep1==1
lab def pid7cat 0"str GOP" 1"str DEM"
lab val pid7cat pid7cat 
tab pid7cat

tab ideo1
recode ideo1 (1=0 "ext lib")(2=.17)(3=.33)(4 8=.5)(5=.67)(6=.83)(7=1 "ext con")(else=.), gen(lc7cat)
tab lc7cat
sum lc7cat

tab race

//getting s.e's
ttest age=female
ttest lc7cat=pid7cat

recode pid7cat (0 1=1)(.17 .83=.67)(.33 .67=.33)(.5=0), gen(strpid)

//risk scale
tab risk1
recode risk1 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(risk1r)
recode risk2 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=.), gen(risk2r)
recode risk3 risk4 risk5 risk6 (1=0)(2=.25)(3=.5)(4=.75)(5=1)(else=.), gen(risk3r risk4r risk5r risk6r)
recode risk7 (1=1)(2=.67)(3=.33)(4=0)(else=.), gen(risk7r)
alpha risk1r-risk7r  

gen riskscale = (risk1r+risk2r+risk3r+risk4r+risk5r+risk6r+risk7r)/7
sum risk1r-risk7r
sum riskscale

//getting s.e.
ttest riskscale=risk1

//getting s.e.'s
ttest risk1r=risk2r
ttest risk3r=risk4r
ttest risk5r=risk6r
ttest risk1r=risk7r

pcorr riskscale age01 female income ed7cat pid7cat lc7cat black hisp


//correlation with dospert
//WEBER DOSPERT RISK SCALE
//social risk
recode dsr1 dsr7 dsr21 dsr22 dsr27 dsr28 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(social1 social2 social3 social4 social5 social6)

//rec risk
recode dsr2 dsr11 dsr13 dsr19 dsr24 dsr25 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(rec1 rec2 rec3 rec4 rec5 rec6)

//financial-gambling risk
recode dsr3 dsr8 dsr14 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(gam1 gam2 gam3)

//financial-invest risk
recode dsr4 dsr12 dsr18 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(inv1 inv2 inv3)
 
//health/safety risk
recode dsr5 dsr15 dsr17 dsr20 dsr23 dsr26 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(health1 health2 health3 health4 health5 health6)

//ethical risk
recode dsr6 dsr9 dsr10 dsr16 dsr29 dsr30 (1=0)(2=.17)(3=.33)(4=.5)(5=.67)(6=.83)(7=1)(else=.), gen(ethic1 ethic2 ethic3 ethic4 ethic5 ethic6)

gen socialrisk = (social1+social2+social3+social4+social5+social6)/6
alpha social1-social6

gen recrisk = (rec1+rec2+rec3+rec4+rec5+rec6)/6
alpha rec1-rec6

gen gamrisk = (gam1+gam2+gam3)/3
alpha gam1 gam2 gam3

gen invrisk = (inv1+inv2+inv3)/3
alpha inv1 inv2 inv3

gen econrisk = (gam1+gam2+gam3+inv1+inv2+inv3)/6
alpha gam1 gam2 gam3 inv1 inv2 inv3

gen healthrisk = (health1+health2+health3+health4+health5+health6)/6
alpha health1-health6

gen ethicrisk = (ethic1+ethic2+ethic3+ethic4+ethic5+ethic6)/6
alpha ethic1-ethic6

alpha social1-social6 rec1-rec6 gam1-gam3 inv1-inv3 health1-health6 ethic1-ethic6

gen dospert = (socialrisk+recrisk+econrisk+healthrisk+ethicrisk)/5
corr dospert riskscale
//correlate at .58

corr riskscale dospert socialrisk recrisk econrisk healthrisk ethicrisk 
//riskscale correlates best with recreational risk and overall scale

//TEN ITEM PERSONALITY INVENTORY
sum tipi*
mvdecode tipi*, mv(-99)
gen extraversion = (tipi1-tipi6+6)/12
gen agreeableness= (tipi7-tipi2+6)/12
gen conscientiousness= (tipi3-tipi8+6)/12
gen neuroticism = (tipi4-tipi9+6)/12
gen openness = (tipi5-tipi10+6)/12
sum extra-open
pwcorr riskscale extraversion agreeableness conscientiousness neuroticism openness, sig

//participation
//future participation
recode futurepart_1 futurepart_2 futurepart_3 futurepart_4 futurepart_5 futurepart_6 futurepart_7 futurepart_8 futurepart_9 (1=1)(2=.75)(3=.5)(4=.25)(5=0)(else=.), gen(futprot futloc futepet futpet futreldon futpoldon futmtg futinvite futflyer) 
sum futprot futloc futepet futpet futreldon futpoldon futmtg futinvite futflyer
recode vote08 mtg0810 sign0810 vol0810 donate0810 (1=1)(2=0)(else=.), gen(ppnvote ppnmtg ppnsign ppnvol ppndon)
sum ppnvote ppnmtg ppnsign ppnvol ppndon
recode vol12 commorg12 contact12 protest12 petition12 religdon12 (1=1)(2=0)(else=.), gen(ppnloc ppncommorg ppncon ppnprot ppnpet ppnreligdon)
sum ppnloc ppncommorg ppncon ppnprot ppnpet ppnreligdon

probit ppnvote riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnvote
probit ppnmtg riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnmtg
probit ppnsign riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnsign
probit ppnvol riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnvol
probit ppndon riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppndon
est table ppnvote ppnmtg ppnsign ppnvol ppndon, b(%9.2f) star(.1 .05 .01) stats(ll N)
//all sig except vote in 2008

probit ppnvol riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnvol
probit ppncom riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppncom
probit ppncon riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppncon
probit ppnprot riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnprot
probit ppnpet riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnpet
probit ppnreli riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ppnreli
est table ppnvol ppncom ppncon ppnprot ppnpet ppnreli, b(%9.2f) star(.1 .05 .01) stats(ll N)
//all positive and sig except religious donation

oprobit futprot riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futprot
oprobit futloc riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futloc
oprobit futepet riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futepet
oprobit futpet riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futpet
oprobit futreldon  riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futreldon
oprobit futpoldon riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futpoldon
oprobit futmtg riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futmtg
oprobit futinvite riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futinvite
oprobit futflyer riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store futflyer
est table futprot futloc futepet futpet, b(%9.2f) star(.1 .05 .01) stats(ll N) eq(1)
est table futreldon futpoldon futmtg futinvite futflyer, b(%9.2f) star(.1 .05 .01) stats(ll N) eq(1)
//all sig and pos but relig don (neg and sig)

mean ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote 

save "C:/CDK WORK/risk/SSI survey/codedSSI.dta", replace
cd "C:/CDK WORK/risk/SSI survey/"
use "codedSSI.dta", clear

//CREATING A FIGURE
program riskscale
tempname memhold
postfile `memhold' b_riskscale se_riskscale using riskSSI, replace
foreach v of varlist ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote {
   oprobit `v' riskscale age01 strpid lc7cat ed7cat faminc black hisp
post `memhold' (_b[riskscale]) (_se[riskscale]) 
} 
postclose `memhold'
end
riskscale

use riskSSI
gen DV = _n
lab def DV 1"Attended campaign rally" 2"Posted campaign sign" 3"Worked as campaign volunteer" 4"Made campaign donation" 5"Served on local board" 6"Worked on local issue" 7"Contacted official" 8"Protested" 9"Signed petition" 10"Donated to religious org" 11"Future protest" 12"Future local meeting" 13"Future e-petition" 14"Future paper petition" 15"Future political donation" 16"Future political meeting" 17"Future recruit pol meeting" 18"Future political flyers" 19"Future religious donation" 20"Voted", modify
lab val DV DV

gen LB = b_riskscale-1.96*se_riskscale
gen UB = b_riskscale+1.96*se_riskscale
sum LB UB b se if DV==19
lab var b "Coefficient on Risk Acceptance"
lab var DV "Participatory Act"
eclplot b LB UB DV, horiz xline(0, lpattern(dash)) ylabel(1(1)20) xlabel(-2(2)2) scheme(s1mono)


//DOSPERT
use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear
//USING DOSPERT
program dospert
tempname memhold
postfile `memhold' b_dospert se_dospert using dospert, replace
foreach v of varlist ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote {
   oprobit `v' dospert age01 strpid lc7cat ed7cat faminc black hisp
post `memhold' (_b[dospert]) (_se[dospert]) 
} 
postclose `memhold'
end
dospert

save "C:/CDK WORK/risk/SSI survey/codedSSI.dta", replace

use dospert
gen DV = _n
lab def DV 1"Attended campaign rally" 2"Posted campaign sign" 3"Worked as campaign volunteer" 4"Made campaign donation" 5"Served on local board" 6"Worked on local issue" 7"Contacted official" 8"Protested" 9"Signed petition" 10"Donated to religious org" 11"Future protest" 12"Future local meeting" 13"Future e-petition" 14"Future paper petition" 15"Future political donation" 16"Future political meeting" 17"Future recruit pol meeting" 18"Future political flyers" 19"Future religious donation" 20"Voted", modify
lab val DV DV

gen LB = b_-1.96*se_
gen UB = b_+1.96*se_
sum LB UB b se if DV==19
lab var b "Coefficient on 30-item DOSPERT"
lab var DV "Participatory Act"
eclplot b LB UB DV, horiz xline(0, lpattern(dash)) ylabel(1(1)20) xlabel(-2(2)2) scheme(s1mono)


use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear
//robustness check: civic skills
sum civic*
recode civicskill_1 civicskill_2 civicskill_3 civicskill_4 (1=1)(2=0)(else=.), gen(cs_letter cs_meeting cs_chair cs_present)
gen cskills = (cs_letter+cs_meeting+cs_chair+cs_present)/4
alpha cs*

program cskills
tempname memhold
postfile `memhold' b_riskscale se_riskscale using cskills, replace
foreach v of varlist ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote {
   oprobit `v' riskscale cskills age01 strpid lc7cat ed7cat faminc black hisp
post `memhold' (_b[riskscale]) (_se[riskscale]) 
} 
postclose `memhold'
end
cskills

use cskills, clear
gen DV = _n
lab def DV 1"Attended campaign rally" 2"Posted campaign sign" 3"Worked as campaign volunteer" 4"Made campaign donation" 5"Served on local board" 6"Worked on local issue" 7"Contacted official" 8"Protested" 9"Signed petition" 10"Donated to religious org" 11"Future protest" 12"Future local meeting" 13"Future e-petition" 14"Future paper petition" 15"Future political donation" 16"Future political meeting" 17"Future recruit pol meeting" 18"Future political flyers" 19"Future religious donation" 20"Voted", modify
lab val DV DV

gen LB = b_riskscale-1.96*se_riskscale
gen UB = b_riskscale+1.96*se_riskscale
lab var b "Coefficient on Risk Acceptance"
lab var DV "Participatory Act"
eclplot b LB UB DV, horiz xline(0, lpattern(dash)) ylabel(1(1)20) xlabel(-2(2)2) scheme(s1mono)

//PERSONALITY
use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear

program tipi
tempname memhold
postfile `memhold' b_riskscale se_riskscale using tipi, replace
foreach v of varlist ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote {
   oprobit `v' riskscale extraversion openness agreeableness conscientiousness neuroticism age01 strpid lc7cat ed7cat faminc black hisp
   est store `v'
post `memhold' (_b[riskscale]) (_se[riskscale]) 
} 
postclose `memhold'
end
tipi

use tipi, clear
gen DV = _n
lab def DV 1"Attended campaign rally" 2"Posted campaign sign" 3"Worked as campaign volunteer" 4"Made campaign donation" 5"Served on local board" 6"Worked on local issue" 7"Contacted official" 8"Protested" 9"Signed petition" 10"Donated to religious org" 11"Future protest" 12"Future local meeting" 13"Future e-petition" 14"Future paper petition" 15"Future political donation" 16"Future political meeting" 17"Future recruit pol meeting" 18"Future political flyers" 19"Future religious donation" 20"Voted", modify
lab val DV DV

gen LB = b_-1.96*se_
gen UB = b_+1.96*se_
sum LB UB b se if DV==19
lab var b "Coefficient on Risk Acceptance"
lab var DV "Participatory Act"
eclplot b LB UB DV, horiz xline(0, lpattern(dash)) ylabel(1(1)20) xlabel(-2(2)2) scheme(s1mono)

use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear
//mechanism
recode mechanism_1 mechanism_2 mechanism_3 mechanism_4 mechanism_5 mechanism_6 mechanism_7 mechanism_8 mechanism_9 (1=1)(2=.5)(3=0)(else=.), gen(mech_excite mech_new mech_learn mech_diff mech_ideals mech_people mech_duty mech_share mech_neverknow)
pwcorr riskscale mech_excite-mech_neverknow
//works the way one would expect

oprobit mech_excite riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store excite
oprobit mech_new riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store new
oprobit mech_learn riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store learn
oprobit mech_diff riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store diff
oprobit mech_ideals riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store ideals
oprobit mech_people riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store people
oprobit mech_duty riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store duty
oprobit mech_share riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store share
oprobit mech_neverknow riskscale age01 strpid lc7cat ed7cat faminc black hisp
est store never
est table excite new learn diff, b(%9.2f) star(.1 .05 .01) eq(1) stats(ll N)
est table ideals people duty share never , b(%9.2f) star(.1 .05 .01) eq(1) stats(ll N)

save "C:/CDK WORK/risk/SSI survey/codedSSI.dta", replace

use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear
program drop mech
program mech
tempname memhold
postfile `memhold' b_riskscale se_riskscale using mech, replace
foreach v of varlist mech_excite-mech_neverknow {
   oprobit `v' riskscale age01 strpid lc7cat ed7cat faminc black hisp 
post `memhold' (_b[riskscale]) (_se[riskscale]) 
} 
postclose `memhold'
end
mech

use mech 
gen DV = _n
lab def DV 1"It's exciting to participate" 2"I like doing new things" 3"I want to learn about politics & gov" 4"There's a chance of making a difference" 5"I want to work with people who share my ideals" 6"I want to work with people I enjoy" 7"I have a duty as a citizen" 8"I am the kind of person who does my share" 9 "You never know how things will turn out", modify
lab val DV DV

gen LB = b_-1.96*se_
gen UB = b_+1.96*se_
sum LB UB b se if DV==19
lab var b "Risk Acceptance"
lab var DV "Mechanism"
eclplot b LB UB DV, horiz xline(0, lpattern(dash)) ylabel(1(1)9) xlabel(0(2)2) scheme(s1mono)
table DV, c(mean b_risk)

recode DV(1=2)(2=1)(9=3)(3=4)(8=5)(4=6)(6=7)(5=8)(7=9), gen(newDV)

lab def newDV 1"I like doing new things" 2"It's exciting to participate" 3 "You never know how things will turn out" 4"I want to learn about politics & gov" 5"I am the kind of person who does my share" 6"There's a chance of making a difference" 7"I want to work with people I enjoy" 8"I want to work with people who share my ideals" 9"I have a duty as a citizen" , modify
lab val newDV newDV
lab var newDV "Mechanism"
eclplot b LB UB newDV, horiz xline(0, lpattern(dash)) ylabel(1(1)9) xlabel(0(2)2) scheme(s1mono)



//TYING MECHANISM TO DIFFERENT ACTS
use "C:/CDK WORK/risk/SSI survey/codedSSI.dta", clear
corr mech_* ppnmtg ppnsign ppnvol ppndon ppnvol ppncom ppncon ppnprot ppnpet ppnreli futprot futloc futepet futpet futpoldon futmtg futinvite futflyer futreldon ppnvote 


